ServerEvents.recipes((event) => {
  //for enderman overhaul compat
  event
    .shapeless(`minecraft:ender_pearl`, [
      `#ftbevolution:ender_pearl_variations`,
    ])
    .id(`ftbevolution:pearl_conversion`);

  event
    .shapeless(`8x actuallyadditions:tiny_coal`, [`minecraft:coal`])
    .id(`ftbevolution:tiny_coal`);

  event
    .shapeless(`8x actuallyadditions:tiny_charcoal`, [`minecraft:charcoal`])
    .id(`ftbevolution:tiny_charcoal`);

  event
    .stonecutting(
      "immersiveengineering:storage_steel",
      "#c:storage_blocks/steel"
    )
    .id("ftbevolution:storage_steel_cutting");
  event
    .stonecutting(
      "ftbmaterials:steel_block",
      "immersiveengineering:storage_steel"
    )
    .id("ftbevolution:storage_steel_cutting_reverse");

  event
    .shapeless(`9x minecraft:redstone`, [`#c:storage_blocks/redstone`])
    .id(`ftbevolution:redstone_conversion`);
  event
    .shaped("utilitarian:redstone_clock", ["SRS", "RTR", "SRS"], {
      S: "#c:stones",
      R: "#c:dusts/redstone",
      T: "minecraft:redstone_torch",
    })
    .id("ftbevolution:redstone_clock");

  event
    .shaped("ftbmaterials:platinum_raw_ore", ["EEE", "E E", "EEE"], {
      E: "mysticalagriculture:platinum_essence",
    })
    .id("ftbevolution:platinum");

  event
    .shaped("ae2:silicon", ["   ", "EEE", "   "], {
      E: "mysticalagriculture:silicon_essence",
    })
    .id("ftbevolution:silicon");

  //diamond gear
  event
    .shaped("ftbmaterials:diamond_gear", [" D ", "DGD", " D "], {
      D: "minecraft:diamond",
      G: "ftbmaterials:iron_gear",
    })
    .id("ftbevolution:diamond_gear");

  event
    .custom({
      type: "mekanism:enriching",
      input: { count: 1, tag: "mekanism:dirty_dusts/aluminum" },
      output: { count: 1, id: "ftbevolution:xy_aluminum_dust" },
    })
    .id("ftbevolution:xy_aluminum_dust_enriching");

  const cookedMaterials = [
    {
      output: "ftbmaterials:tin_ingot",
      input: "#c:raw_materials/tin",
      id: "tin",
    },
    {
      output: "ftbmaterials:osmium_ingot",
      input: "#c:raw_materials/osmium",
      id: "osmium",
    },
    {
      output: "xycraft_world:aluminum_ingot",
      input: "#c:raw_materials/xy_aluminum",
      id: "xy_aluminum",
    },
    {
      output: "xycraft_world:aluminum_ingot",
      input: "#c:ores/aluminum",
      id: "aluminum_ore",
    },
    {
      output: "ftbmaterials:lead_ingot",
      input: "#c:raw_materials/lead",
      id: "lead",
    },
    {
      output: "ftbmaterials:lead_ingot",
      input: "#c:ores/lead",
      id: "lead_ore",
    },
    {
      output: "ftbmaterials:silver_ingot",
      input: "#c:ores/silver",
      id: "silver_ore",
    },
    {
      output: "ftbmaterials:nickel_ingot",
      input: "#c:raw_materials/nickel",
      id: "nickel",
    },
    {
      output: "ftbmaterials:nickel_ingot",
      input: "#c:ores/nickel",
      id: "nickel_ore",
    },
    {
      output: "xycraft_world:aluminum_ingot",
      input: "#c:dusts/xy_aluminum",
      id: "xy_alu_dust",
    },    
  ];

  cookedMaterials.forEach((material) => {
    event
      .smelting(material.output, material.input)
      .xp(0.5)
      .id(`ftbevolution:smelt_${material.id}`);

    event
      .blasting(material.output, material.input)
      .id(`ftbevolution:blasting_${material.id}`);
  });

  event
    .smelting(
      "9x xycraft_world:aluminum_ingot",
      "#c:storage_blocks/xy_raw_aluminum"
    )
    .xp(0.5)
    .id("ftbevolution:smelt_raw_aluminum");

  event
    .shaped("functionalstorage:dripping_upgrade", ["dsd", "rir", "dld"], {
      d: "#c:ore_bearing_ground/deepslate",
      s: "minecraft:pointed_dripstone",
      r: "#c:dusts/redstone",
      i: "enderio:grains_of_infinity",
      l: "mcwlights:lava_lamp",
    })
    .id("ftbevolution:dripping_upgrade");

  event
    .shaped(
      "modern_industrialization:steam_mining_drill",
      ["fdd", "PDd", "bPf"],
      {
        P: "ftbmaterials:iron_plate",
        f: "minecraft:furnace",
        b: "minecraft:bucket",
        d: "minecraft:diamond",
        D: "modern_industrialization:copper_drill_head",
      }
    )
    .id("ftbevolution:steam_mining_drill");

  //explorer's compass
  event
    .shaped("explorerscompass:explorerscompass", ["BAB", "ACA", "BAB"], {
      A: "ftbmaterials:netherite_nugget",
      B: "minecraft:amethyst_shard",
      C: "ftbmaterials:diamond_gear",
    })
    .id("ftbevolution:explorerscompass");

  event
    .shaped("paganbless:black_thorn_sapling", ["SD ", "DD ", "   "], {
      S: "minecraft:oak_sapling",
      D: "#c:dyes/black",
    })
    .id("ftbevolution:black_thorn_sapling");

  //fix Patchouli books
  event.shapeless(
    Item.of(
      'patchouli:guide_book[patchouli:book="irons_spellbooks:iss_guide_book"]'
    ),
    ["minecraft:book", "irons_spellbooks:arcane_essence"]
  );
  event.shapeless(
    Item.of('patchouli:guide_book[patchouli:book="mysticalagriculture:guide"]'),
    ["minecraft:book", "mysticalagriculture:inferium_essence"]
  );

  event
    .shapeless(
      'mekanism:creative_energy_cube[mekanism:side_config={config:{energy:{eject:1b,side:{back:"output",bottom:"output",front:"output",left:"output",right:"output",top:"output"}},items:{side:{back:"input",bottom:"input",front:"output",left:"input",right:"input",top:"input"}}}},mekanism:energy={energy_containers:[L;9223372036854775807L]}]',
      ["mekanism:basic_energy_cube", "ftbevolution:creative_ascension"]
    )
    .id("ftbevolution:creative_energy_cube");
  event
    .shapeless("xycraft_machines:fluid_selector", [
      "xycraft_machines:extractor",
      "ftbevolution:creative_ascension",
      "xycraft_machines:valve",
    ])
    .id("ftbevolution:creative_fluid_selector");
  event
    .shapeless("xycraft_machines:item_selector", [
      "xycraft_machines:extractor",
      "ftbevolution:creative_ascension",
      "xycraft_machines:soaryn_box",
    ])
    .id("ftbevolution:creative_item_selector");

  event
    .shapeless(
      "mekanism:elite_control_circuit",
      "modern_industrialization:analog_circuit"
    )
    .id("ftbevolution:elite_control_circuit");
  event
    .shapeless(
      "modern_industrialization:analog_circuit",
      "mekanism:elite_control_circuit"
    )
    .id("ftbevolution:elite_control_circuit_rev");
  event
    .shapeless(
      "mekanism:ultimate_control_circuit",
      "modern_industrialization:electronic_circuit"
    )
    .id("ftbevolution:ultimate_control_circuit");
  event
    .shapeless(
      "modern_industrialization:electronic_circuit",
      "mekanism:ultimate_control_circuit"
    )
    .id("ftbevolution:ultimate_control_circuit_rev");
  event
    .shapeless("ae2:creative_energy_cell", [
      "ae2:energy_acceptor",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_energy_cell");
  event
    .shapeless(
      'ironjetpacks:jetpack[ironjetpacks:jetpack_id="ironjetpacks:creative",rarity="epic"]',
      [
        'ironjetpacks:jetpack[ironjetpacks:jetpack_id="ironjetpacks:wood"]',
        "ftbevolution:creative_ascension",
      ]
    )
    .id("ftbevolution:creative_jetpack");
  event
    .shapeless("fargostalismans:soul_of_flight_mastery", [
      "fargostalismans:abominable_energy",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_soul_of_flight");
  event
    .shapeless("mekanism:creative_chemical_tank", [
      "mekanism:basic_chemical_tank",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_chemical_tank");
  event
    .shapeless("pneumaticcraft:creative_compressed_iron_block", [
      "pneumaticcraft:compressed_iron_block",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_compressed_iron_block");
  event
    .shapeless("pneumaticcraft:creative_compressor", [
      "pneumaticcraft:manual_compressor",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_compressor");
  event
    .shapeless("ars_nouveau:creative_source_jar", [
      "ars_nouveau:source_jar",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_source_jar");
  event
    .shapeless("mysticalagriculture:creative_soulium_dagger", [
      "mysticalagriculture:soulium_dagger",
      "ftbevolution:creative_ascension",
    ])
    .id("ftbevolution:creative_soulium_dagger");
  event
    .custom({
      type: "immersiveengineering:alloy",
      input0: {
        tag: "c:gems/amethyst",
      },
      input1: {
        item: "simpleteleporters:ender_shard",
      },
      result: {
        basePredicate: {
          item: "the_afterdark:teleport_catalyst",
        },
        count: 1,
      },
    })
    .id("ftbevolution:teleport_catalyst");

  event
    .custom({
      type: "enderio:alloy_smelting",
      energy: 2000,
      experience: 0.3,
      inputs: [
        {
          count: 1,
          tag: "c:gems/amethyst",
        },
        {
          count: 1,
          item: "simpleteleporters:ender_shard",
        },
      ],
      output: {
        count: 1,
        id: "the_afterdark:teleport_catalyst",
      },
    })
    .id("ftbevolution:teleport_catalyst_alloy_smelting");

  event
    .custom({
      type: "treetap:tap_extract",
      log: {
        item: "integrateddynamics:menril_log",
      },
      processing_time: 1200,
      result: {
        id: "integrateddynamics:bucket_menril_resin",
      },
      collect_bucket: true,
      display_fluid: {
        fluid: "integrateddynamics:menril_resin",
      },
      fluid_color: "#00eaff",
    })
    .id("ftbevolution:menril_resin");

  event
    .shapeless("ftbmaterials:copper_dust", "mekanism:dust_copper")
    .id("ftbevolution:copper_dust_exchange");
});
